﻿using System;
using Microsoft.SPOT;
using Microsoft.SPOT.Presentation;
using Microsoft.SPOT.Presentation.Controls;
using Microsoft.SPOT.Presentation.Media;
using System.Threading;
using GT = Gadgeteer;
using GTM = Gadgeteer.Modules;
using Gadgeteer.Modules.GHIElectronics;
using Gadgeteer.Modules.Seeed;

namespace CellularRadioTest
{
    public partial class Program
    {
        CellularRadio cellularRadio = new CellularRadio(4);
        void ProgramStarted()
        {
            
            /******************************************************************************************
            Access modules defined in the designer by typing their name:                            
            
            e.g.  button
                  camera1

            Initialize event handlers here.
            e.g. button.ButtonPressed += new GTM.MSR.Button.ButtonEventHandler(button_ButtonPressed);             
            ***************************************************************************************** */

            // Do one-time tasks here
            Debug.Print("Program Started");

            //cellularRadio = new GTM.Seeed.CellularRadio(4);
            cellularRadio.DebugPrintEnabled = true;
            cellularRadio.PowerOn(5);
            button.ButtonPressed += new Button.ButtonEventHandler(button_ButtonPressed);
            button.TurnLEDOff();
            resetButton.ButtonPressed += new Button.ButtonEventHandler(resetButton_ButtonPressed);

            //cellularRadio.PINStateReceived += new CellularRadio.PINStateReceivedHandler(cellularRadio_PINEvent);
            //cellularRadio.NetworkRegistrationReceived += new CellularRadio.NetworkRegistrationReceivedHandler(cellularRadio_NetworkRegistrationEvent);
            cellularRadio.SmsReceived += new CellularRadio.SmsReceivedHandler(cellularRadio_NewSMSEvent);
            //cellularRadio.IncomingCall += new CellularRadio.IncomingCallHandler(cellularRadio_IncomingCall);
            cellularRadio.SmsRetrieved += new CellularRadio.SmsRetrievedHandler(cellularRadio_SMSReady);
            //cellularRadio.PhoneActivityReceived += new CellularRadio.PhoneActivityReceivedHandler(cellularRadio_PhoneActivityReady);
            //cellularRadio.ContactOpen += new CellularRadio.ContactOpenHandler(cellularRadio_ContactReady);
            //cellularRadio.ClockReceived += new CellularRadio.ClockReceivedHandler(cellularRadio_ClockReady);
            //cellularRadio.SignalStrengthReceived += new CellularRadio.SignalStrengthReceivedHandler(cellularRadio_SignalStrengthReady);
            //cellularRadio.OperatorReceived += new CellularRadio.OperatorReceivedHandler(cellularRadio_OperatorReady);
            //cellularRadio.SMSListReceived += new CellularRadio.SMSListReceivedHandler(cellularRadio_SMSListReady);
            //cellularRadio.ConnectedLineEvent += new CellularRadio.ConnectedLineEventHandler(cellularRadio_ConnectedLineEvent);
            //cellularRadio.NoCarrier += new CellularRadio.NoCarrierHandler(cellularRadio_NoCarrierEvent);
            cellularRadio.ModuleInitialized += new CellularRadio.ModuleInitializedHandler(cellularRadio_ModuleInitialized);
        }

        void cellularRadio_ModuleInitialized(CellularRadio sender)
        {
            Debug.Print("MODULE INITIALIZED");
        }

        void cellularRadio_NoCarrierEvent(CellularRadio sender)
        {
            Debug.Print("NO CARRIER EVENT");
        }

        void cellularRadio_ConnectedLineEvent(CellularRadio sender, string number)
        {
            Debug.Print("CONNECTED: " + number);
        }

        void cellularRadio_SMSListReady(CellularRadio sender, System.Collections.ArrayList smsList)
        {
            if (smsList != null)
            {
                Debug.Print("SMS LIST");
                foreach (GTM.Seeed.CellularRadio.Sms message in smsList)
                {
                    Debug.Print("FROM: " + message.TelephoneNumber);
                    Debug.Print("MSG: " + message.TextMessage);
                    Debug.Print("WHEN: " + message.Timestamp);
                    Debug.Print("STATUS: " + message.Status + "\n");
                    Debug.Print("POS:" + message.Index);
                }
            }
        }

        void cellularRadio_OperatorReady(CellularRadio sender, string operatorName)
        {
            if (operatorName != null)
                Debug.Print("OPERATOR: " + operatorName);
            else
                Debug.Print("NO OPERATOR WAS FOUND");
        }

        void cellularRadio_SignalStrengthReady(CellularRadio sender, CellularRadio.SignalStrengthType signalStrength)
        {
            Debug.Print("SIGNAL STRENGTH: " + signalStrength);
        }

        void cellularRadio_ClockReady(CellularRadio sender, DateTime clock)
        {
            Debug.Print("CLOCK: "+clock.ToString("r"));
        }

        void cellularRadio_ContactReady(CellularRadio sender, CellularRadio.Contact contact)
        {
            Debug.Print("NAME: " + contact.name);
            Debug.Print("TEL: " + contact.telephoneNumber);
        }

        void cellularRadio_PhoneActivityReady(CellularRadio sender, CellularRadio.PhoneActivityType activity)
        {
            Debug.Print("Phone Activtiy: " + activity);
        }

        void resetButton_ButtonPressed(Button sender, Button.ButtonState state)
        {
            if (cellularRadio.SendSms("1591919220", "HELLO") != GTM.Seeed.CellularRadio.ReturnedState.OK)
            {
                Debug.Print("Retrieve clock failed");
            }
        }

        void cellularRadio_SMSReady(CellularRadio sender, CellularRadio.Sms message)
        {
            if (message != null)
            {
                Debug.Print("RETRIEVED");
                Debug.Print("FROM: " + message.TelephoneNumber);
                Debug.Print("MSG: " + message.TextMessage);
                Debug.Print("WHEN: " + message.Timestamp);
                Debug.Print("STATUS: " + message.Status);
                Debug.Print("POS:" + message.Index);
            }
        }

        void cellularRadio_IncomingCall(CellularRadio sender, string caller)
        {
            Debug.Print("NEW CALL: " + caller);
        }

        void cellularRadio_NewSMSEvent(CellularRadio sender, CellularRadio.Sms message)
        {
            if (message != null)
            {
                Debug.Print("NEW SMS");
                Debug.Print("FROM: " + message.TelephoneNumber);
                Debug.Print("MSG: " + message.TextMessage);
                Debug.Print("WHEN: " + message.Timestamp);
                Debug.Print("STATUS: " + message.Status);
                Debug.Print("POS:" + message.Index);
            }
        }

        void cellularRadio_NetworkRegistrationEvent(CellularRadio sender, CellularRadio.NetworkRegistrationState networkState)
        {
            Debug.Print("NETWORK EVENT " + networkState);
        }

        void button_ButtonPressed(Button sender, Button.ButtonState state)
        {
            Debug.Print("BUTTON BEGIN"); 

            /*
             * Power ON test
             */
            //cellularRadio.PowerOn = false;
            //cellularRadio.PowerOn = false;
           // cellularRadio.PowerOn = true;
           // cellularRadio.PowerOn = true;

            /*
             * PIN Event Test
             */
            cellularRadio.SendATCommand("AT+CPIN?");

            /*
             * Network Event Test
             */
            cellularRadio.SendATCommand("AT+CREG?");

            /*
             * SMS Test
             */
            //cellularRadio.SendSms("15919192620", "HELLO");
            //cellularRadio.SendSms("447801881396", "HELLO");

            /*
             * Receive Voice Call Test
             */
            //if (!button.IsLedOn)
            //{
            //    cellularRadio.PickUp();
            //    button.TurnLEDOn();
            //}
            //else
            //{
            //    cellularRadio.HangUp();
            //    button.TurnLEDOff();
            //}

            /*
             * Make voice call Test
             */
            
            cellularRadio.Dial("13672739313");
            

            /*
             * Read SMS Test
             */
            //cellularRadio.RetrieveSms(1,true);

            /*
             * Delete SMS Test
             */
            //cellularRadio.DeleteSMS(1);

            /*
             * Redial Test
             */
            //cellularRadio.Dial("159919620");
            //Thread.Sleep(3000);
            //cellularRadio.HangUp();
            //Thread.Sleep(3000);
            //cellularRadio.Redial();

            /*
             * Phone Activity Test
             */
            //cellularRadio.RequestPhoneActivity();

            /*
             * Phonebook Test
             */
            //cellularRadio.SaveContact( 1,"447527202098", "Eduardo");
            //Thread.Sleep(1000);
            //cellularRadio.RequestContact(1);

            /* 
             * Clock test
             */
            //cellularRadio.RequestClock();

            /*
             * IMEI test
             */
            //if (cellularRadio.RetrieveImei() != GTM.Seeed.CellularRadio.ReturnedState.OK)
            //{
            //    Debug.Print("Retrieve IMEI failed");
            //}

            /*
             * Signal Strength Test
             */
            //cellularRadio.RequestSignalStrength();

            /*
             * Operator Test
             */
            //cellularRadio.RequestOperator();

            /*
             * Get unread test
             */
            //cellularRadio.RequestSMSList(GTM.Seeed.CellularRadio.SMSState.All);

            /*
             * Attach GPRS Test
             */
            //cellularRadio.AttachGPRS("orangeinternet", "", "");
            //cellularRadio.SendATCommand("AT+CIPSTATUS");

            /*
             * Delete all sms test
             */
            //cellularRadio.RetrieveSmsList(CellularRadio.SmsState.All);
            //Thread.Sleep(1000);
            //cellularRadio.DeleteAllSms();
            //Thread.Sleep(1000);
            //cellularRadio.RetrieveSmsList(CellularRadio.SmsState.All);


            Debug.Print("BUTTON END");
        }

        void cellularRadio_PINEvent(CellularRadio sender, CellularRadio.PINState pinState)
        {
            Debug.Print("PIN: " + pinState);
        }
    }
}
